# -*- coding: utf-8 -*-
"""histo.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1e-py9peqCcmTchM6H21BLVbXJL5B-6iM
"""

import pandas as pd
f = pd.read_csv('a.csv')     # THE FILE NAME GOES HERE

import numpy as np
ifcn_use = np.array(f['Question 1 - [IFCN - Usefulness]'])
for i in range(2,7):
  ifcn_use = np.append(ifcn_use,np.array(f[f'Question {i} - [IFCN - Usefulness]']))

cov_use = np.array(f['Question 1 - [Covbot - Usefulness]'])
for i in range(2,7):
  cov_use = np.append(cov_use,np.array(f[f'Question {i} - [Covbot - Usefulness]']))

cov_val = np.array(f['Question 1 - [Covbot - Value]'])
for i in range(2,7):
  cov_val = np.append(cov_val,np.array(f[f'Question {i} - [Covbot - Value]']))

ifcn_val = np.array(f['Question 1 - [IFCN - Value]'])
for i in range(2,7):
  ifcn_val = np.append(ifcn_val,np.array(f[f'Question {i} - [IFCN - Value]']))

cov_pr = np.array(f['Question 1 - [Covbot - Precision]'])
for i in range(2,7):
  cov_pr = np.append(cov_pr,np.array(f[f'Question {i} - [Covbot - Precision]']))
ifcn_pr = np.array(f['Question 1 - [IFCN - Precision]'])
for i in range(2,7):
  ifcn_pr = np.append(ifcn_pr,np.array(f[f'Question {i} - [IFCN - Precision]']))

cov_cr = np.array(f['Question 1 - [Covbot - Credibility]'])
for i in range(2,7):
  cov_cr = np.append(cov_cr,np.array(f[f'Question {i} - [Covbot - Credibility]']))
ifcn_cr = np.array(f['Question 1 - [IFCN - Credibility]'])
for i in range(2,7):
  ifcn_cr = np.append(ifcn_cr,np.array(f[f'Question {i} - [IFCN - Credibility]']))

cov_eu = np.array(f['Question 1 - [Cobot - Ease of Use]'])
for i in range(2,7):
  cov_eu = np.append(cov_eu,np.array(f[f'Question {i} - [Cobot - Ease of Use]']))
ifcn_eu = np.array(f['Question 1 - [IFCN - Ease of Use]'])
for i in range(2,7):
  ifcn_eu = np.append(ifcn_eu,np.array(f[f'Question {i} - [IFCN - Ease of Use]']))

for i in ifcn_eu:
  print(i)

# TAKING THE MEAN AND STANDARD DEVIATION
import matplotlib.pyplot as plt 
ifcn_data = []
ifcn_data.append(np.mean(ifcn_use))
ifcn_data.append(np.mean(ifcn_cr))
ifcn_data.append(np.mean(ifcn_val))
ifcn_data.append(np.mean(ifcn_eu))
ifcn_data.append(np.mean(ifcn_pr))
cov_data = []
cov_data.append(np.mean(cov_use))
cov_data.append(np.mean(cov_cr))
cov_data.append(np.mean(cov_val))
cov_data.append(np.mean(cov_eu))
cov_data.append(np.mean(cov_pr))

ifcn_st = []
ifcn_st.append(np.std(ifcn_use))
ifcn_st.append(np.std(ifcn_cr))
ifcn_st.append(np.std(ifcn_val))
ifcn_st.append(np.std(ifcn_eu))
ifcn_st.append(np.std(ifcn_pr))
cov_st = []
cov_st.append(np.std(cov_use))
cov_st.append(np.std(cov_cr))
cov_st.append(np.std(cov_val))
cov_st.append(np.std(cov_eu))
cov_st.append(np.std(cov_pr))

# PLOTTING THE FIGURE
materials = ['Usefulness', 'Credibility', 'Value','Ease of Use','Precision']
x_pos = np.arange(len(materials))
error = [ifcn_st,cov_st]
data = [ifcn_data,cov_data]
fig, ax = plt.subplots()
ax.bar(x_pos+0.00,data[0],yerr=error[0],align='center', alpha=0.5, ecolor='black', capsize=10,width = 0.25,label='IFCN Factcheck')
ax.bar(x_pos+0.25,data[1],yerr=error[1],align='center', alpha=0.5, ecolor='black', capsize=10,width = 0.25,label = 'Covbot')
ax.set_ylabel('Scores')
ax.set_xticks(x_pos)
ax.set_xticklabels(materials)
leg = ax.legend(bbox_to_anchor=(0.77, 0.95))
ax.set_title('Chatbot Comparison Survey')
ax.yaxis.grid(True)
plt.savefig('result.png')
plt.show()

